
function [selected,trashed,timetracesselected,timetracestrashed]= cellselectionfunction1(xaxis,timetraces) %,celllabel)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% INPUT ARGUMENTS:

%%% xaxis : x-axis (row with actual time labels)
%%% timetraces : timetraces to analyze (each column is a cell)
%%% celllabel : each row contains 3 cells (cell number - X - Y)

%%% OUTPUT ARGUMENTS:

%%% selected : each row contains 3 cells (selected cell number - X - Y)
%%% trashed : each row contains 3 cells (trashed cell number - X - Y)
%%% timetracesselected :timetraces of the selected cells (1 col = 1 cell)
%%% timetracestrashed :timetraces of the trashed cells (1 col = 1 cell)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%% Asks you the number of displays and how to call Excel files

prompt = 'How many displays do you want in each row/column?\n';
n = input(prompt);
prompt = 'Insert name of file to save (EX: SelectedSlope.csv between quotes)\n';
selectedsave = input(prompt);
prompt = 'Insert name of file to save (EX: TrashedSlope.csv between quotes)\n';
trashedsave = input(prompt);

tracesdisplay=n*n;
ncell = length(timetraces(1,:));
ndisplays=ceil(ncell/tracesdisplay);  %defines number of pages

selected = zeros(ncell,3); %creates a column, all cells are unselected at first

for ii = 1 : ndisplays %% at this level, actions are done in the same display
    
    next=0; %doesn't go to next page yet
   
    figuretitle = ['Select relevant activators: Page' num2str(ii) 'of' num2str(ndisplays)];
    figure('Name',figuretitle,'NumberTitle','off','Color',[1 1 1])
    
    for jj = 1 : n %% j are the rows, z are the coloumns
        for zz = 1 : n %% at this level, actions are done in each subplot
       
            subplotnum = n*n*(ii-1)+(jj-1)*n+zz;
            
            if min(subplotnum-1,ncell) == ncell %stops the loop when activators are finished
                break
            end
               
            subplot (n,n,(jj-1)*n+zz)
            plot(xaxis,timetraces(:,subplotnum),'LineWidth',2,'Tag',sprintf('%d',subplotnum),'buttondownfcn',...
            @clickTest) %When you click on subplot, it prints cell number in Command Window

            xlim([0 ceil(max(xaxis))]);
            ylim([min(timetraces(:)) max(timetraces(:))]);
            
        end
    end
    
    btn = uicontrol('Style', 'pushbutton', 'String', 'Next',...
        'Position', [500 15 50 30],...
        'Callback',@continueButton2); %It creates a 'Next' button, that when you click recalls the function continueButton2

    while next==0   
        pause(0.01);
    end
    
    close(gcf)
    
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Saves selected and trashed cells for further data analysis
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

not = ~selected;

%%% This loop transforms not (logical array) in trashed (double array):

trashed = zeros(size(not)); 
for i = 1:size(not,2)
    trashed(:,i) = not(:,i);
end

% %%% This loop fills selected/trashed logical matrixes with cell number and X-Y:
% 
% for ii = 1:ncell
%     
%     selected(ii,:) = celllabel(ii,:).*selected(ii,:);
%     trashed(ii,:) = celllabel(ii,:).*trashed(ii,:);
% end
% 
% %%% Here it gets rid of zeros:
% 
% selected( ~any(selected,2), : ) = [];  %rows
% trashed( ~any(trashed,2), : ) = [];  %rows
% 
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% Creates SelectedCells.csv to find cells of interest on ImageJ
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% ss = selected(:,2:3);
% csvwrite(selectedsave,ss,1,0);
% 
% name1 = selectedsave;
%     tmp1 = csvread(name1,1,0);
%     X = tmp1(:,1);
%     Y = tmp1(:,2);
%     T1 = table(X,Y);
%     writetable(T1,name1,'Delimiter',',','QuoteStrings',true);
%     
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% Creates TrashedCells.csv to find cells of interest on ImageJ
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% tt = trashed(:,2:3);
% csvwrite(trashedsave,tt,1,0);
% 
% name2 = trashedsave;
%     tmp2 = csvread(name2,1,0);
%     X = tmp2(:,1);
%     Y = tmp2(:,2);
%     T2 = table(X,Y);
%     writetable(T2,name2,'Delimiter',',','QuoteStrings',true);
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% Creates time traces matrix of the selected/trashed cells
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% clearvars aa ii tmp numselected numtrashed
% 
% numselected = length(selected(:,1));
% numtrashed = length(trashed(:,1));
% 
% 
% 
% for ii=1:numselected
%     aa = find(celllabel(:,1)==selected(ii,1));
%     tmp = timetraces(:,aa);
%     timetracesselected(:,ii) = tmp;
% end
% 
% clearvars aa ii tmp
% 
% for ii=1:numtrashed
%     aa = find(celllabel(:,1)==trashed(ii,1));
%     tmp = timetraces(:,aa);
%     timetracestrashed(:,ii) = tmp;
% end

        
%%%%%%%%%%%%%%%%%%%
%%% FUNCTIONS
%%%%%%%%%%%%%%%%%%%

function [next]=continueButton2(qstring,title,str1,str2,default)

%NEXT BUTTON: asks if you can go to the next page

qstring='Are you done selecting traces in this Page?';
title='Traces Quality Control';
str1='Yes';
str2='No';
default='Yes';

choice = questdlg(qstring,title,str1,str2,default);
                % Handle response
                    switch choice
                        case 'Yes';
                            
                            % saves figure

                            if(exist('figdir','var') == 1)
                                saveFigs(figdir,'format','png','name','measurement');
                            else
                                saveFigs('img','format','png','name','measurement');
                            end
    
                            next=1;
                            
                        case 'No';
                           % disp([choice 'Waiting for selection of traces'])
                            next=0;
                    end
                    
assignin('caller', 'next', next);
end


function clickTest(line_handle, event)

%SUBPLOT SELECTION: allows you to select some graphs

  selected = evalin('caller', 'selected');
    
  current_tag = get(line_handle, 'Tag');
  subplotnum = str2num(current_tag);
  
  
  selected(subplotnum,:) = [1 1 1]; %changes state of selected traces from 0 to 1
  set(line_handle, 'Color', [1, 0, 0]);
  
  assignin('caller', 'selected', selected);
     
end

end

